<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateInvoiceItemsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoice_items', function (Blueprint $table) {
            $table->unsignedBigInteger('quotation_item_id')->nullable()->after('invoice_id');
            $table->unsignedBigInteger('jewellery_id')->nullable()->after('quotation_item_id');
            $table->unsignedBigInteger('job_id')->nullable()->after('jewellery_id');
            
            $table->unsignedBigInteger('category_id')->nullable()->after('item_code');
            $table->unsignedBigInteger('gold_color_id')->nullable()->after('category_id');


            $table->string("additional_material")->nullable()->after('gold_color_id');
            $table->integer('material_quantity')->nullable()->after('additional_material');

            $table->dropColumn('item_description');
            $table->longText('description')->nullable()->after('additional_info');

            $table->enum('customer_received',[0,1])->comment('0->Unchecked, 1->Checked')->nullable()->after('description');

            $table->dropColumn('actual_price');
            // $table->dropColumn('price');
            $table->decimal('price', $precision = 10, $scale = 2)->nullable()->after('customer_received')->change();

            $table->string('valued_at')->nullable()->after('price');
            $table->decimal('sub_total', $precision = 10, $scale = 2)->nullable()->after('valued_at');

            $table->foreign('quotation_item_id')->references('id')->on('quotation_items')->onDelete('cascade');
            $table->foreign('jewellery_id')->references('id')->on('jewelleries')->onDelete('cascade');
            $table->foreign('job_id')->references('id')->on('jobs')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('gold_color_id')->references('id')->on('gold_colors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
