<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateQuotationItemsTable3 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quotation_items', function (Blueprint $table) {
            $table->decimal('gold_weight', $precision = 10, $scale = 2)->nullable()->after('category_id');
            $table->decimal('gold_cost', $precision = 10, $scale = 2)->nullable()->after('gold_weight');
            $table->decimal('craftsmanship_cost', $precision = 10, $scale = 2)->nullable()->after('gold_cost');
            $table->decimal('polishing', $precision = 10, $scale = 2)->nullable()->after('craftsmanship_cost');
            $table->decimal('size', $precision = 11, $scale = 2)->nullable()->after('polishing');
            $table->enum('is_sample_provided', [0,1])->nullable()->after('size');
            $table->longText('sample_description')->nullable()->after('is_sample_provided');
            $table->decimal('setting_cost', $precision = 10, $scale = 2)->nullable()->after('sample_description');
            $table->decimal('earing_pin', $precision = 10, $scale = 2)->comment('mm')->nullable()->after('setting_cost');
            $table->decimal('backing_cost', $precision = 10, $scale = 2)->nullable()->after('earing_pin');
            $table->enum('backing_type', ['Flat', 'Teacup', 'Loop'])->nullable()->after('backing_cost');
            $table->decimal('backing_size', $precision = 10, $scale = 2)->comment('mm')->nullable()->after('backing_type');
            $table->integer('backing_quantity')->nullable()->after('backing_size');
            $table->enum('claw', ['Eagle', 'Round', 'Square'])->nullable()->after('backing_quantity');

            $table->text('additional_information')->nullable()->after('claw');

            $table->string("additional_material")->nullable()->after('gold_color_id');
            $table->integer('material_quantity')->nullable()->after('additional_material');
            $table->renameColumn('actual_price', 'price')->nullable()->change();
            $table->dropColumn("material");
            $table->dropColumn('quantity');
            $table->dropColumn('weight');
            $table->dropColumn('unit_price');

            $table->string('customer_signature', 255)->nullable()->comment('signature image')->after('claw');
            $table->string('sales_representative_signature', 255)->nullable()->comment('signature image')->after('customer_signature');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
