<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateConsignmentsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('consignments', function (Blueprint $table) {
            $table->dropColumn('consignment_id');
            $table->string('consignment_no', 50)->comment('unique alpha-numeric code')->nullable()->after('id');
            $table->dropColumn('date');
            $table->date('reference_date')->comment('Date of Creation/Request')->after('consignment_no');
            $table->date('receiving_date')->nullable()->comment('Date of Receiving')->after('staff_signature');
            $table->renameColumn('staff_signature', 'sales_representative_signature');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
