<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJobsTable10 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jobs', function (Blueprint $table) {
           // $table->dropForeign('jobs_worksmith_id_foreign');
            // $table->dropIndex(['worksmith_id']); // Drops index 'jobs_worksmith_id_foreign'
            // $table->dropColumn('worksmith_id');
            $table->unsignedBigInteger('worksmith_id')->nullable()->after('staff_id');
            $table->foreign('worksmith_id')->references('id')->on('worksmiths')->onDelete('cascade');
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
