<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWorksmithsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('worksmiths', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('fullname');
            $table->string('email')->unique();
            $table->string('country_code', 5)->nullable();
            $table->string('phone',15)->nullable();
            $table->date('dob')->nullable();
            $table->enum('gender',[0,1])->comment('0->Female, 1->Male')->nullable();
            $table->string('address',255)->nullable();
            $table->string('remarks')->nullable();
            $table->string('image')->nullable();
            $table->enum('status',['Active','Inactive'])->default('Active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('worksmiths');
    }
}
