<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConsignmentItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consignment_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('consignment_id')->nullable();
            // $table->date('date');
            $table->string('item_code', 50)->comment('unique alpha-numeric code')->nullable();
            $table->string('item_name', 50)->nullable();
            // Bepoke
            $table->longText('description');
            $table->unsignedBigInteger('category_id');

            // Inventory
            $table->string('weight', 20);
            $table->string('unit', 20);
            $table->decimal('unit_price', $precision = 10, $scale = 2);
            $table->decimal('total_price', $precision = 10, $scale = 2);

            // $table->enum('status',['Active','Inactive'])->default('Active');
            $table->timestamps();

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('consignment_id')->references('id')->on('consignments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consignment_items');
    }
}
