<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConsignmentReviewCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consignment_review_costs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('consignment_id')->nullable();

            $table->decimal('sub_total', $precision = 10, $scale = 2)->nullable();
            $table->decimal('gst_percent', $precision = 10, $scale = 2)->nullable()->comment('%');
            $table->decimal('gst_amount', $precision = 10, $scale = 2)->nullable();
            $table->decimal('total', $precision = 10, $scale = 2);
            $table->decimal('mark_up', $precision = 10, $scale = 2)->nullable()->comment('SGD -> Singapore Dollar');
             $table->decimal('usd_exchange_rate', $precision = 10, $scale = 2)->nullable()->comment('1 USD =  "x" SGD');
            $table->decimal('mark_up_usd', $precision = 10, $scale = 2)->nullable()->comment('USD -> United States Dollar');
            $table->decimal('hkd_exchange_rate', $precision = 10, $scale = 2)->nullable()->comment('1 HKD =  "x" SGD');
            $table->decimal('mark_up_hkd', $precision = 10, $scale = 2)->nullable()->comment('HKD -> Hong Kong Dollar');
            $table->timestamps();

            $table->foreign('consignment_id')->references('id')->on('consignments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consignment_review_costs');
    }
}
