<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConsignmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consignments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('consignment_id');
            $table->date('date');
            $table->unsignedBigInteger('staff_id')->comment('or handled_by/staff as id')->nullable();

            $table->unsignedBigInteger('customer_id')->nullable();
            
            $table->string('customer_name')->nullable();
            $table->string('customer_email')->nullable();
            $table->string('country_code', 5)->nullable();
            $table->string('customer_phone',15)->nullable();
            
            $table->string('customer_signature', 255)->comment('signature image')->nullable();
            $table->string('staff_signature', 255)->comment('signature image')->nullable();

            $table->enum('status',['Active','Inactive'])->default('Active');
            $table->timestamps();

            $table->foreign('staff_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consignments');
    }
}
