<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateQuotationItemsTable2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quotation_items', function (Blueprint $table) {
            $table->dropForeign('quotation_items_type_id_foreign');
            $table->dropColumn('type_id');

            $table->unsignedBigInteger("gold_color_id")->nullable()->after('category_id');
            $table->string('valued_at')->nullable()->after('quantity');
            $table->enum('type_name', ['Inventory', 'Bespoke', 'Repair'])->nullable()->after('item_code');
            
            $table->foreign('gold_color_id')->references('id')->on('gold_colors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
