<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateQuotationItemsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quotation_items', function (Blueprint $table) {
            $table->string("material")->nullable()->after('category_id');
            $table->longText('description')->nullable()->after('material');
            $table->enum('customer_received',[0,1])->comment('0->Unchecked, 1->Checked')->nullable()->after('description');
            $table->unsignedBigInteger('jewellery_id')->nullable()->change();
            $table->string('item_code', 10)->comment('unique alpha-numeric code')->nullable()->change();
            $table->decimal('weight', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('actual_price', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('unit_price', $precision = 10, $scale = 2)->nullable()->change();
            $table->integer('quantity')->nullable()->change();
            $table->decimal('sub_total', $precision = 10, $scale = 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
