<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateUsersTable3 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->renameColumn('name', 'fullname')->change();
            $table->date('dob')->nullable()->after('phone');
            $table->enum('gender',[0,1])->comment('0->Female, 1->Male')->nullable()->after('dob');
            $table->string('address',255)->nullable()->after('gender');
            $table->string('username', 50)->unique()->nullable()->after('email_verified_at');
            $table->string('remarks')->nullable()->after('address');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
