<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotation_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('quotation_id')->nullable();
            $table->unsignedBigInteger('jewellery_id');
            $table->string('item_code', 10)->comment('unique alpha-numeric code');
            $table->unsignedBigInteger('type_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->decimal('weight', $precision = 10, $scale = 2);
            $table->decimal('actual_price', $precision = 10, $scale = 2);
            $table->decimal('unit_price', $precision = 10, $scale = 2);
            $table->integer('quantity');
            $table->decimal('sub_total', $precision = 10, $scale = 2);
            $table->string('drawing_image')->nullable();
            $table->timestamps();

            $table->foreign('quotation_id')->references('id')->on('quotations')->onDelete('cascade');
            $table->foreign('jewellery_id')->references('id')->on('jewelleries')->onDelete('cascade');
            $table->foreign('type_id')->references('id')->on('types')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotation_items');
    }
}
