<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('staff_id')->comment('handled_by/staff as id');
            $table->string('staff_name', 255)->nullable();
            $table->unsignedBigInteger('job_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->string('customer_name', 255)->nullable();
            $table->string('customer_email', 190)->nullable();
            $table->string('country_code', 5)->nullable();
            $table->string('customer_phone', 15)->nullable();
            $table->date('reference_date');
            $table->time('reference_time');
            $table->decimal('sub_total', $precision = 10, $scale = 2)->nullable();
            $table->decimal('gst_percent', $precision = 10, $scale = 2)->nullable()->comment('%');
            $table->decimal('gst_amount', $precision = 10, $scale = 2)->nullable();
            $table->decimal('total', $precision = 10, $scale = 2);
            $table->text('remarks')->nullable();
            $table->text('layaway')->nullable();
            $table->timestamps();

            $table->foreign('staff_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('job_id')->references('id')->on('jobs')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotations');
    }
}
