<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateAdminsTable3 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('admins', function (Blueprint $table) {
            $table->renameColumn('firstname', 'fullname');
            $table->dropColumn('lastname');
            $table->string('password')->nullable()->change();
            $table->unsignedBigInteger('role_id')->nullable()->change();
            $table->enum('account_type',['Super-Admin', 'Sub-Admin', 'Staff'])->nullable()->after('image');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        
    }
}
