<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateReviewCostsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('review_costs', function (Blueprint $table) {
            $table->decimal('cost_price', $precision = 10, $scale = 2)->nullable()->comment('may be fixed input cost')->after('job_id');

            $table->decimal('mark_up', $precision = 10, $scale = 2)->nullable()->comment('SGD -> Singapore Dollar')->change();

            $table->decimal('usd_exchange_rate', $precision = 10, $scale = 2)->nullable()->comment('1 USD =  "x" SGD')->after('mark_up');
            $table->decimal('hkd_exchange_rate', $precision = 10, $scale = 2)->nullable()->comment('1 HKD =  "x" SGD')->after('mark_up_usd');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
