<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('review_costs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('jewellery_id')->nullable();
            $table->unsignedBigInteger('job_id')->nullable();

            $table->decimal('sub_total', $precision = 10, $scale = 2)->nullable();
            $table->decimal('gst_percent', $precision = 10, $scale = 2)->nullable()->comment('%');
            $table->decimal('gst_amount', $precision = 10, $scale = 2)->nullable();
            $table->decimal('total', $precision = 10, $scale = 2);
            $table->decimal('mark_up', $precision = 10, $scale = 2)->nullable()->comment('SGD');
            $table->decimal('mark_up_usd', $precision = 10, $scale = 2)->nullable()->comment('USD -> United States Dollar');
            $table->decimal('mark_up_hkd', $precision = 10, $scale = 2)->nullable()->comment('HKD -> Hong Kong Dollar');
            $table->timestamps();

            $table->foreign('jewellery_id')->references('id')->on('jewelleries')->onDelete('cascade');
            $table->foreign('job_id')->references('id')->on('jobs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('review_costs');
    }
}
