<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJewelleriesTable6 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jewelleries', function (Blueprint $table) {
            $table->string('item_code', 50)->comment('unique alpha-numeric code')->nullable()->change();
            $table->date('estimate_completion')->nullable()->after('date')->change();

            $table->unsignedBigInteger('gold_color_id')->nullable()->change();
            $table->decimal('size', $precision = 11, $scale = 2)->nullable()->change();

            $table->decimal('gold_cost', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('workmanship_cost', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('pollising_cost', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('setting_cost', $precision = 10, $scale = 2)->nullable()->change();

            $table->decimal('total_cost', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('sale_amount', $precision = 10, $scale = 2)->nullable()->change();
        });

        DB::statement("ALTER TABLE `jewelleries` CHANGE `is_sample_provided` `is_sample_provided` ENUM('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL;");

        \DB::statement("ALTER TABLE `jewelleries` CHANGE `claw` `claw` ENUM('Eagle', 'Round', 'Square') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
