<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJewelleryLoosePiecesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     
     */
    public function up()
    {
        Schema::create('jewellery_loose_pieces', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('jewellery_id');
            $table->string('stock_no', 15);
            $table->decimal('weight', $precision = 10, $scale = 2);
            $table->decimal('unit_price', $precision = 10, $scale = 2);
            $table->decimal('price', $precision = 10, $scale = 2);
            $table->timestamps();

            $table->foreign('jewellery_id')->references('id')->on('jewelleries')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jewellery_loose_pieces');
    }
}
