<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJobsTable2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jobs', function (Blueprint $table) {
            $table->unsignedBigInteger('job_type_id')->nullable()->change();
            $table->unsignedBigInteger('customer_id')->nullable()->change()->after('staff_id');
            
            $table->dropColumn('jewellery_pin');
            $table->decimal('earing_pin', $precision = 10, $scale = 2)->comment('mm')->nullable()->after('setting_cost');

            $table->decimal('backing_cost', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('backing_size', $precision = 10, $scale = 2)->comment('mm')->nullable()->change();
            $table->integer('backing_quantity')->nullable()->change();
            $table->string('omega_backing', 100)->nullable()->change();
            $table->string('hook', 100)->comment('Spring Hook/Lobster Hook')->nullable()->change();
            $table->string('pearl_stud', 100)->comment('Spring Hook/Lobster Hook')->nullable()->change();

            $table->dropColumn('country_code');
            $table->dropColumn('customer_phone');
            $table->dropColumn('customer_name');
            $table->dropColumn('customer_email');
        });

        \DB::statement("ALTER TABLE `jobs` CHANGE `backing_type` `backing_type` ENUM('Flat', 'Teacup', 'Loop') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
