<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJewelleriesTable3 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jewelleries', function (Blueprint $table) {
            $table->unsignedBigInteger('staff_id')->comment('or handled_by/staff as id')->nullable()->after('id');
            $table->unsignedBigInteger('job_id')->nullable()->after('staff_id');
            $table->unsignedBigInteger('customer_id')->nullable()->after('job_id');
            
            $table->dropColumn('jewellery_pin');
            $table->decimal('earing_pin', $precision = 10, $scale = 2)->comment('mm')->nullable()->after('setting_cost');

            $table->decimal('backing_cost', $precision = 10, $scale = 2)->nullable()->change();

            $table->decimal('backing_size', $precision = 10, $scale = 2)->comment('mm')->nullable()->change();
            $table->integer('backing_quantity')->nullable()->change();
            $table->string('omega_backing', 100)->nullable()->change();
            $table->string('hook', 100)->comment('Spring Hook/Lobster Hook')->nullable()->change();
            $table->string('pearl_stud', 100)->comment('Spring Hook/Lobster Hook')->nullable()->change();

            $table->dropColumn('handled_by');
            $table->dropColumn('country_code');
            $table->dropColumn('customer_phone');
            $table->dropColumn('customer_name');
            $table->dropColumn('customer_email');


            $table->foreign('staff_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('job_id')->references('id')->on('jobs')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
        });

        \DB::statement("ALTER TABLE `jewelleries` CHANGE `backing_type` `backing_type` ENUM('Flat', 'Teacup', 'Loop') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
