<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJobsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jobs', function (Blueprint $table) {
            $table->string('item_code', 10)->comment('unique alpha-numeric code')->nullable()->after('id');
            $table->string('drawing_image', 255)->comment('paint image')->nullable()->after('size');
            $table->string('country_code', 5)->nullable()->after('sale_amount');
            $table->string('customer_signature', 255)->comment('signature image')->change();
            $table->string('sales_representative_signature', 255)->comment('signature image')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
