<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJewelleriesTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jewelleries', function (Blueprint $table) {
            $table->dropColumn('image');

            // Inventory
            $table->string('stock_no', 20)->nullable()->change();
            $table->string('weight', 20)->nullable()->change();
            $table->decimal('unit_price', $precision = 10, $scale = 2)->nullable()->change();
            $table->decimal('price', $precision = 10, $scale = 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
