<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->bigIncrements('id');
            // ------------------ Job starts here -----------------

            $table->unsignedBigInteger('job_type_id');
            $table->unsignedBigInteger('staff_id')->comment('or handled_by/staff as id')->nullable();
            // Custom Job
            $table->unsignedBigInteger('category_id')->nullable()->comment('inventory_category');
            $table->decimal('gold_weight', $precision = 10, $scale = 2)->comment('or weight')->nullable();
            $table->decimal('unit_price', $precision = 10, $scale = 2)->nullable()->comment('for both Custom,Rrepaire');
            $table->decimal('material_cost', $precision = 10, $scale = 2)->comment('or gold_cost')->nullable();
            $table->decimal('craftsmanship_cost', $precision = 10, $scale = 2)->comment('or workmanship_cost')->nullable();
            $table->string('setting_type',100)->nullable();
            $table->decimal('polishing', $precision = 10, $scale = 2)->comment('or pollising_cost')->nullable();
            $table->decimal('finishing', $precision = 10, $scale = 2)->nullable();
            $table->decimal('total_cost', $precision = 10, $scale = 2)->nullable()->comment('sum of all costs');
            $table->string('gem_or_stones',100)->nullable();
            $table->string('stone_cut',100)->nullable();
            $table->string('stone_size',11)->nullable();
            $table->integer('quantity_of_stones')->nullable();
            $table->enum('is_reference_drawing', [1,0])->nullable();
            $table->enum('is_sample_image', [1,0])->nullable();
            $table->enum('job_status', ['Not started', 'On going', 'Delayed', 'Completed', 'Received'])->nullable();

            // Repaire Job

            // $table->string('customer_name')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            // $table->string('name_of_item')->nullable();
            // $table->string('item_code')->nullable();
            // $table->integer('quantity')->nullable();
            // $table->string('image')->nullable();

            $table->date('reference_date')->nullable();
            // ------------------------ Job ends here ----------------------

            // --------------------- Jewellery starts here -----------------
            $table->date('date');
            $table->unsignedBigInteger('type_id')->comment('releted to jewellery table');

            // Bepoke
            $table->longText('description')->nullable();
            $table->unsignedBigInteger('gold_color_id')->nullable();
            $table->string('size', 11)->nullable();

            // Repaire
            $table->enum('is_sample_provided', [0,1])->nullable();
            $table->longText('sample_description')->nullable();
            $table->decimal('setting_cost', $precision = 10, $scale = 2)->nullable();
            $table->decimal('jewellery_pin', $precision = 10, $scale = 2)->comment('mm')->nullable();
            $table->decimal('backing_cost', $precision = 10, $scale = 2)->nullable();
            $table->enum('backing_type', ['Flat', 'Teacup', 'Loop'])->nullable();
            $table->decimal('backing_size', $precision = 10, $scale = 2)->comment('mm');
            $table->integer('backing_quantity')->nullable();
            $table->string('omega_backing', 100)->nullable();
            $table->string('hook', 100)->comment('Spring Hook/Lobster Hook')->nullable();
            $table->string('pearl_stud', 100)->comment('Spring Hook/Lobster Hook')->nullable();

            $table->enum('claw', ['Eagle', 'Round', 'Square'])->nullable();

            // Inventory
            $table->decimal('price', $precision = 10, $scale = 2)->comment('weight x material_cost')->nullable();
            $table->decimal('sale_amount', $precision = 10, $scale = 2)->nullable();

            // Common details
            $table->string('customer_phone', 15)->nullable();
            $table->string('customer_name', 255)->nullable();
            $table->string('customer_email', 190)->nullable();
            $table->string('customer_signature', 255)->nullable();
            $table->string('sales_representative_signature', 255)->comment('staff signature')->nullable();
            $table->enum('status',['Active','Inactive'])->default('Active');
            // --------------------- Jewellery ends here --------------------
            $table->timestamps();


            // --------------- Jewellery foreign key starts here -------------
            $table->foreign('staff_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('type_id')->references('id')->on('types')->onDelete('cascade');
            $table->foreign('gold_color_id')->references('id')->on('gold_colors')->onDelete('cascade');
            // ---------------- Jewellery foreign key ends here ---------------

            // ------------------ Job foreign key starts here ---------------
            $table->foreign('job_type_id')->references('id')->on('job_types')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
            // ---------------- Job foreign key ends here --------------------
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jobs');
    }
}
