<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJewelleryImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jewellery_images', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('jewellery_id');
            $table->string('image');
            $table->enum('status',['Active','Inactive'])->default('Active');
            $table->timestamps();

            $table->foreign('jewellery_id')->references('id')->on('jewelleries')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jewellery_images');
    }
}
