<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJewelleriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jewelleries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('item_code');
            $table->date('date');
            $table->unsignedBigInteger('type_id');

            // Bepoke
            $table->longText('description');
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('gold_color_id');
            $table->string('size', 11);
            $table->string('image', 255)->nullable();

            // Repaire
            $table->enum('is_sample_provided', [0,1]);
            $table->longText('sample_description')->nullable();
            $table->decimal('gold_cost', $precision = 10, $scale = 2);
            $table->decimal('workmanship_cost', $precision = 10, $scale = 2);
            $table->decimal('pollising_cost', $precision = 10, $scale = 2);
            $table->decimal('setting_cost', $precision = 10, $scale = 2);
            $table->decimal('jewellery_pin', $precision = 10, $scale = 2)->comment('mm');
            $table->decimal('backing_cost', $precision = 10, $scale = 2);
            $table->enum('backing_type', ['Flat', 'Teacup', 'Loop']);
            $table->decimal('backing_size', $precision = 10, $scale = 2)->comment('mm');
            $table->integer('backing_quantity');
            $table->string('omega_backing', 100);
            $table->string('hook', 100)->comment('Spring Hook/Lobster Hook');
            $table->string('pearl_stud', 100)->comment('Spring Hook/Lobster Hook');

            $table->enum('claw', ['Eagle', 'Round', 'Square']);

            // Inventory
            $table->string('stock_no', 20);
            $table->string('weight', 20);
            $table->decimal('unit_price', $precision = 10, $scale = 2);
            $table->decimal('price', $precision = 10, $scale = 2);
            $table->decimal('total_cost', $precision = 10, $scale = 2);
            $table->decimal('sale_amount', $precision = 10, $scale = 2);

            // Common details
            $table->string('handled_by', 255);
            $table->string('customer_phone', 15);
            $table->string('customer_name', 255);
            $table->string('customer_email', 190);
            $table->string('customer_signature', 255);
            $table->string('sales_representative_signature', 255);
            $table->enum('status',['Active','Inactive'])->default('Active');
            $table->timestamps();

            $table->foreign('type_id')->references('id')->on('types')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('gold_color_id')->references('id')->on('gold_colors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jewelleries');
    }
}
