<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Log;

// use App\Models\Notification;

class JobOverDueAlertNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    private $notification_details; 

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($notification_details) 
    { 
        $this->notification_details = $notification_details;  
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail','database']; 
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        try{
            return (new MailMessage) 
            ->subject('Job Over Due Alert')
            ->from('vandana@braintechnosys.com', 'Sancy') 
            ->greeting($this->notification_details['greeting'])
            ->line($this->notification_details['body'])
            ->line($this->notification_details['thanks']); 
        }catch(\Exception $err){
            Log::error('message error in toMail on JobOverDueAlertNotification :'. $err->getMessage());
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable) 
    {
        if(is_array($this->notification_details)){
            return [
                'data' => $this->notification_details['data'],
            ];
        }else{
            return [
                'data' => $this->notification_details->data,
            ];
        } 
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    

    public function toDatabase($notifiable) 
    {
        if(is_array($this->notification_details)){
            return [
                'data' => $this->notification_details['data'],
            ];
        }else{
            return [
                'data' => $this->notification_details->data,
            ];
        } 
    }
}
