<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable; //added by ss
use Illuminate\Database\Eloquent\Model;
use File;
use DB;

class Worksmith extends Model
{
    const ZERO = '0';
    const ONE = '1';
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';
    const TAB_ALL = "all";
    const TAB_VIP = "vip";
    const TABLENAME = "worksmiths";
    const IMAGE_PATH = 'img/worksmiths';
    const THUMB_IMAGE_PATH = 'img/worksmiths/thumb';
    const TEMP_PATH = "img/temp/";
    const THUMB_SIZE = 70;

	use  HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'fullname', 'email', 'country_code', 'phone', 'status', 'dob', 'created_at' ];

    protected $fillable = [ 'fullname', 'email', 'country_code', 'phone', 'dob', 'gender', 'address', 'remarks', 'image', 'status' ];
    
    protected $appends = [ 'phone_with_code', 'thumb_image_url', 'image_url' ];


     /* Route notifications for the mail channel.
     *
     * @param  \Illuminate\Notifications\Notification  $notification
     * @return array|string
     */
    public function routeNotificationForMail($notification) {
        return [$this->email => $this->fullname];
    }


    public function worksmith_job()
    {
        return $this->hasMany('\App\Models\Job', 'worksmith_id', 'id');
    }

    public static function getWorksmithsList()
    {
       return $Worksmiths = Worksmith::where('status', self::ACTIVE)->pluck('fullname', 'id')->toArray();
    }

    public static function getPhoneArray()
    {
        return Worksmith::where('status', self::ACTIVE)->distinct()->pluck('phone')->toArray();
    }

    public function getPhoneWithCodeAttribute()
    {
        // return "{$this->country_code ?? ''} {$this->phone}";
        return isset($this->phone) ? ($this->country_code ? $this->country_code.' '.$this->phone : $this->phone) : '-';
    }

    public function getThumbImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::THUMB_IMAGE_PATH).'/'.$value)){
            return asset('public/img/worksmiths/thumb/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH).'/'.$value)){
            return asset('public/img/worksmiths/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }


}
