<?php

namespace App\Models;

// use Spatie\Permission\Traits\HasRoles;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
// use App\Notifications\AdminResetPasswordLink;
use File;
use DB;

class User extends Authenticatable
{
    use  HasFactory, Notifiable, HasApiTokens; // , HasRoles,  HasApiTokens,;

    use \Kyslik\ColumnSortable\Sortable;

    const ZERO = '0';
    const ONE = '1';
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';
    const TAB_ALL = "all";
    const TAB_VIP = "vip";
    const TABLENAME = "users";
    const IMAGE_PATH = 'img/users';
    const THUMB_IMAGE_PATH = 'img/users/thumb';
    const TEMP_PATH = "img/temp/";
    const THUMB_SIZE = 70;

    public $sortable = [ 'id', 'fullname', 'email', 'phone', 'status', 'dob', 'is_vip' ];

    protected $fillable = [ 'fullname', 'email', 'email_verified_at', 'country_code', 'phone', 'dob', 'gender', 'address', 'remarks', 'image', 'is_vip', 'status' ];
    
    protected $appends = [ 'phone_with_code', 'thumb_image_url', 'image_url' ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [ 'password', 'remember_token', 'email_verified_at' ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [ 'email_verified_at' => 'datetime' ];

    public static function getPhoneArray()
    {
        return User::where('status',User::ACTIVE)->distinct()->pluck('phone')->toArray();
    }

    public function scopeToday($query)
    {
        $query->whereDate('created_at', date('Y-m-d'));
    }

    public function invoice()
    {
        return $this->hasMany(Invoice::class, 'customer_id', 'id');
    }

    public static function getPhoneWithCodeArray()
    {
        return User::selectRaw("concat(COALESCE(`country_code`,''),' ', phone) as phone")->where('status',User::ACTIVE)->distinct()->pluck('phone')->toArray(); 
    }

    public function getThumbImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::THUMB_IMAGE_PATH).'/'.$value)){
            return asset('public/img/users/thumb/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image']??'';
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH).'/'.$value)){
            return asset('public/img/users/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getPhoneWithCodeAttribute()
    {
        return isset($this->phone) ? ($this->country_code ? $this->country_code.' '.$this->phone : $this->phone) : '-';
    }


}
