<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Type extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'name', 'status','created_at' ];

    protected $fillable = [ 'name', 'status' ];

    const DEFAULT_SELECT = [ 'id', 'name' ];

    // const BESPOKE = "1";
    // const PURCHASED ="2";

    const BESPOKE = "Bespoke";
    const PURCHASED ="Purchased";

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    // const INVENTORY_TYPE = 1;
    // const BEPOKE_TYPE=2;

    protected static function boot()
    {
        parent::boot();

        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-types');
        Cache::forget('get-types-list');
    }

    public static function getTypes()
    {
        return Cache::rememberForever('get-types', function () {
            return $types = Type::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    }

    public static function getTypesList()
    {
        return Cache::rememberForever('get-types-list', function () {
            return $types_list = Type::where('status','Active')->pluck('name', 'id')->toArray();
        });
    }

    public static function typeById($id)
    {
        $type_name = "";
        $type = Type::where('status','Active')->where('id',$id)->first();
        if($type){
            return $type_name = $type->name;
        }
    }

    public static function getTypeIdByName($name)
    {
        $typeId = 0;
        $type = Type::where('status','Active')->where('name',$name)->first();
        if($type){
            $typeId =  $type->id;
        }
        return $typeId;
    }


}
