<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
	const PENDING = 0;
    const IN_PROGRESS = 1;
    const COMPLETED = 2;
    const FAILED = 3;

    const CREDIT_CARD = 1;
    const CHEQUE = 2;
    const CASH = 3;

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'invoice_id', 'consignment_id',	'total_amount',	'paid_amount', 'balance', 'due', 'is_refund', 'refunded_amount', 'payment_status', 'payment_mode', 'created_at' ];
    
    protected $fillable = [ 'invoice_id', 'consignment_id',	'total_amount',	'paid_amount', 'balance', 'due', 'is_refund', 'refunded_amount', 'payment_status', 'payment_mode' ];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }
    
}
