<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Size extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    const CATEGORY_ARR = [ 'Ring', 'Earing', 'Bracelet', 'Necklace', 'Pendant', 'Brooch' ];
    const UNIT_ARRAY = [ 'Ring'=>'cm', 'Earing'=>'cm', 'Bracelet'=>'inch', 'Necklace'=>'inch', 'Pendant'=>'cm', 'Brooch'=>'cm' ];

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'category_id', 'name', 'status','created_at' ];
    
    protected $fillable = [ 'category_id', 'name', 'status' ];

    const DEFAULT_SELECT = [ 'id', 'category_id', 'name' ];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();
     
        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        }); 
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-sizes'); 
        Cache::forget('get-sizes-list');  
    }

    public static function getSizes()
    {
        return Cache::rememberForever('get-sizes', function () {
            return $types = Size::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    }

    public static function getSizesList()
    {
        return Cache::rememberForever('get-sizes-list', function () {
            return $sizes_list = Size::where('status','Active')->pluck('name','id')->toArray();
        });
    }

    public function category(){
        return $this->belongsTo('\App\Models\Category');
    }

    public function scopeSizeWithUnit() 
    {
        return in_array($this->size->category->name,array_keys(self::UNIT_ARRAY))? self::UNIT_ARRAY[$this->size->category->name] :'-';
    }


}
