<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use CommonHelper;


class Setting extends Model
{
    const YES = 'Yes';
    const No = 'No';

    public $table = "settings";
    
    public $sortable = [ 'id', 'key', 'value', 'group' ];
    
    protected $fillable = [ 'key', 'value', 'group' ];

    private static function deleteCache($model){
        Cache::forget('shopSetting');
        Cache::forget('priceSetting');
    }

    
    public static function shop_settings(){
        $shop_settings = Setting::where('group', 'like','Shop_Settings')->pluck('value', 'key')->toArray();
        return $shop_settings;
    }

    public static function price_settings(){
        $price_settings = Setting::where('group', 'like','Price_Settings')->pluck('value', 'key')->toArray();
        return $price_settings;
    }
    
}
