<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use \Spatie\Permission\Models\Permission;

class Role extends Model
{
    const GUARD_ADMIN = 'Admin';
    const GUARD_WEB   = 'web';
    const ADMIN       = 'Admin';
    const SUPERADMIN  = 'Super Admin';
    const SUBADMIN    = 'Sub-Admin';
    const STAFF       = 'Staff';
    const WORKSMITH   = 'Worksmith';

    use HasFactory;

    protected $fillable = [ 'name', 'guard_name' ];

    protected static function boot()
    {
        parent::boot();

        self::created(function ($model) {
            self::deleteCache($model);
        });

        self::updated(function ($model) {
            self::deleteCache($model);
        });

        self::deleted(function ($model) {
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-role-list');
        Cache::forget('get-role-permission-list');
        Cache::forget('get-jewellery-permission-list');
        Cache::forget('get-job-permission-list');
        Cache::forget('get-worksmith-permission-list');
        Cache::forget('get-customer-permission-list');
        Cache::forget('get-all-permission-list');
        Cache::forget('get-staff-permission-list');
        Cache::forget('get-subAdmin-permission-list');
        Cache::forget('get-quotation-permission-list');
        Cache::forget('get-invoice-permission-list');
        Cache::forget('get-consignment-permission-list');
        Cache::forget('get-setting-permission-list');
        Cache::forget('get-front-quotation-permission-list');
        Cache::forget('get-front-invoice-permission-list');
        Cache::forget('get-front-repair-job-permission-list');
        Cache::forget('get-front-bespoke-job-permission-list');
    }
    
    public function role_has_permission()
    {
        return $this->hasMany(RoleHasPermission::class, 'role_id', 'id');
    }

    public static function roleByName($name)
    {
        $role_id = "";
        $role = Role::where('name', $name)->first();
        if ($role) {
            return $role_id = $role->id;
        }
    }

    public static function roleNameById($id)
    {
        $role_name = "";
        $role = Role::where('id', $id)->first();
        if ($role) {
            return $role_name = $role->name;
        }
    }

    public static function getRoleList()
    {
        $role_id  = Self::roleByName(Self::SUPERADMIN);

        if($role_id){
            // $role_list = Role::where('id', "!=",$role_id)->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
            $role_list = Role::orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        }else{
            $role_list = null;
        }
        return $role_list;     
    }

    public static function getAllPermissions()
    {
        return Cache::rememberForever('get-all-permission-list', function () {
            return $permissions_list = Permission::orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getRolePermissionList()
    {
        return Cache::rememberForever('get-role-permission-list', function () {
            return $permission = Permission::where('module_name','role')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getJewelleryPermissionList()
    {
        return Cache::rememberForever('get-jewellery-permission-list', function () {
            return $permission = Permission::where('module_name','jewellery')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getJobPermissionList()
    {
        return Cache::rememberForever('get-job-permission-list', function () {
            return $permission = Permission::where('module_name','job')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getWorksmithPermissionList()
    {
        return Cache::rememberForever('get-worksmith-permission-list', function () {
            return $permission = Permission::where('module_name','worksmith')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getCustomerPermissionList()
    {
        return Cache::rememberForever('get-customer-permission-list', function () {
            return $permission = Permission::where('module_name','customer')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getStaffPermissionList()
    {
        return Cache::rememberForever('get-staff-permission-list', function () {
            return $permission = Permission::where('module_name','staff')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getQuotationPermissionList()
    {
        return Cache::rememberForever('get-quotation-permission-list', function () {
            return $permission = Permission::where('module_name','quotation')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getInvoicePermissionList()
    {
        return Cache::rememberForever('get-invoice-permission-list', function () {
            return $permission = Permission::where('module_name','invoice')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getConsignmentPermissionList()
    {
        return Cache::rememberForever('get-consignment-permission-list', function () {
            return $permission = Permission::where('module_name','consignment')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getSettingPermissionList()
    {
        return Cache::rememberForever('get-setting-permission-list', function () {
            return $permission = Permission::where('module_name','setting')->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getFrontQuotationPermissionList()
    {
        return Cache::rememberForever('get-front-quotation-permission-list', function () {
            return $permission = Permission::where(['module_name'=>'front_quotation'])->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getFrontInvoicePermissionList()
    {
        return Cache::rememberForever('get-front-invoice-permission-list', function () {
            return $permission = Permission::where(['module_name'=>'front_invoice'])->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getFrontRepairJobPermissionList()
    {
        return Cache::rememberForever('get-front-repair-job-permission-list', function () {
            return $permission = Permission::where(['module_name'=>'front_repair_job'])->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getFrontBespokeJobPermissionList()
    {
        return Cache::rememberForever('get-front-bespoke-job-permission-list', function () {
            return $permission = Permission::where(['module_name'=>'front_bespoke_job'])->orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

}
