<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotationLoosePiece extends Model
{
    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'quotation_id', 'quotation_item_id', 'stock_no', 'weight', 'unit_price', 'price' ];

    protected $fillable = [ 'quotation_id', 'quotation_item_id', 'stock_no', 'weight', 'unit_price', 'price' ];

    public function quotation()
    {
        return $this->belongsTo(Quotation::class, 'quotation_id', 'id');
    }

    public function quotation_item()
    {
        return $this->belongsTo(QuotationItem::class, 'quotation_item_id', 'id');
    }
}
