<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;

class QuotationItemImage extends Model
{
	const IMAGE_PATH = "img/quotations";
    const TEMP_PATH = "img/temp/";
    const TABLENAME = "quotation_item_image";

    use HasFactory;

    public $sortable = [ 'id', 'quotation_id', 'quotation_item_id', 'created_at' ];

    protected $fillable = [ 'quotation_id',	'quotation_item_id', 'image' ];

    protected $appends = [ 'image_url' ];


    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH).'/'.$value)){
            return asset('public/img/quotations/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function quotation_item()
    {
        return $this->belongsTo(QuotationItem::Class, 'quotation_item_id', 'id');
    }


}
