<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;

class QuotationItem extends Model
{
	const BESPOKE = "Bespoke";
    const REPAIR = "Repair";
    const INVENTORY = "Inventory";
    const TAB_INVENTORY = "inventory";
    const TAB_BESPOKE_AND_REPAIR = "bespoke_and_repair";
    const DRAWING_PATH = "img/quotations/drawing_images";
    const ZERO = "0";
    const ONE = "1";

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = ['id', 'quotation_id', 'jewellery_id', 'job_id', 'item_code', 'type_name', 'category_id', 'gold_weight', 'gold_color_id', 'price', 'valued_at', 'quantity', 'sub_total', 'created_at' ];

    protected $fillable = [ 'quotation_id', 'jewellery_id', 'job_id', 'type_name', 'item_code', 'category_id', 'gold_weight', 'gold_cost', 'craftsmanship_cost', 'polishing', 'size', 'is_sample_provided', 'sample_description', 'setting_cost', 'earing_pin','backing_cost', 'backing_type', 'backing_size', 'backing_quantity', 'claw','customer_signature', 'sales_representative_signature','additional_information', 'gold_color_id', 'additional_material', 'material_quantity', 'description', 'customer_received', 'price','valued_at', 'sub_total', 'drawing_image' ];

    protected $appends = [ 'drawing_image_url' ];

    public function jewellery()
    {
       return $this->belongsTo(Jewellery::Class, 'jewellery_id', 'id');
    }

    public function quotation()
    {
       return $this->belongsTo(Quotation::Class, 'quotation_id', 'id');
    }

    public function quotation_item_image()
    {
       return $this->hasMany(QuotationItemImage::Class, 'quotation_item_id', 'id');
    }

    public function quotation_loose_piece()
    {
        return $this->hasMany(QuotationLoosePiece::class, 'quotation_item_id', 'id');
    }

    public function gold_color()
    {
        return $this->belongsTo(GoldColor::class, 'gold_color_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function quotation_item()
    {
       return $this->hasOne(InvoiceItem::Class, 'quotation_item_id', 'id');
    }
    
    //-------------------------------------------------------------------------
    public function scopeToday($query)
    {
        $query->whereDate('quotation_items.created_at', date('Y-m-d'));
    }

    public function scopeBespoke($query)
    {
        $query->where('type_name', self::BESPOKE);
    }

    public function scopeRepair($query)
    {
        $query->where('type_name', self::REPAIR);
    }

    public function scopeInventory($query)
    {
        $query->where('type_name', self::INVENTORY);
    }

    public function scopeBespokeAndRepair($query)
    {
        $query->whereIn('type_name', [self::BESPOKE, self::REPAIR]);
    }

    public function getDrawingImageUrlAttribute()
    {
        $value = $this->attributes['drawing_image'];
    
        if (!empty($value) && File::exists(public_path(Self::DRAWING_PATH) . '/' . $value)) {
            return asset('public/img/quotations/drawing_images/' . $value);
        }
    }

}

