<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Permission extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'guard_name', 'module_name'];

    protected static function boot()
    {
        parent::boot();

        self::created(function ($model) {
            self::deleteCache($model);
        });

        self::updated(function ($model) {
            self::deleteCache($model);
        });

        self::deleted(function ($model) {
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-permission-list');
        Cache::forget('get-permission-list-with-route_name'); 
    }

    public function role_has_permission()
    {
        return $this->hasMany(RoleHasPermission::class, "permission_id", "id");
    }

    public static function getPermissionList()
    {
        return Cache::rememberForever('get-permission-list', function () {
            return $permission_list = Permission::orderBy('id', 'ASC')->pluck('name', 'id')->toArray();
        });
    }

    public static function getPermissionListWithRouteName()
    {     
          
        Cache::forget('get-permission-list-with-route_name'); 
        return Cache::rememberForever('get-permission-list-with-route_name', function () {
            $permission_by_route=array();
            $permissionByRoute =  Permission::pluck('name','route_name')->toArray(); 
            foreach($permissionByRoute as $key => $value){
             $route_name= explode('|', $key); 
             foreach($route_name as $key2 => $value2){
                  $permission_by_route[$value2][]=$value;
             }
            } 
            return $permission_by_route;
        });
    }
    
}
