<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class MaterialUnit extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'name', 'status','created_at' ];
    
    protected $fillable = [ 'name', 'status' ];

    const DEFAULT_SELECT = [ 'id', 'name' ];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();
     
        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        }); 
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-material-units');  
        Cache::forget('get-material-units-list');  
    }

    public static function getMaterialUnits()
    {
        return Cache::rememberForever('get-material-units', function () {
            return $material_units = MaterialUnit::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    } 
    
    public static function getMaterialUnitsList()
    {
        return Cache::rememberForever('get-material-units-list', function () {
            return $material_units_list = MaterialUnit::where('status','Active')->pluck('name', 'id')->toArray();
        });
    } 

    public function material()
    {
        return $this->hasMany('\App\Models\Material');
    }

}
