<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Material extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'material_code', 'name', 'material_unit_id', 'quantity', 'status', 'created_at' ];
     
    protected $fillable = [ 'material_code', 'name', 'material_unit_id', 'quantity', 'status' ];

    protected static function boot()
    {
        parent::boot();
     
        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        }); 
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-materials');  
    }

    public static function getMaterials()
    {
        return Cache::rememberForever('get-materials', function () {
            return $materials = Material::where('status','Active')->pluck('name','id')->toArray();
        });
    } 

    public function material_unit()
    {
        return $this->belongsTo('\App\Models\MaterialUnit');
    }

}
