<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class JobType extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';
    const BESPOKE = 'Bespoke';
    const REPAIR = 'Repair';

    use HasFactory;

    const DEFAULT_SELECT = [ 'id', 'name' ];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();

        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-job-types');
        Cache::forget('get-job-types-list');
    }

    public static function getJobTypes()
    {
        return Cache::rememberForever('get-job-types', function () {
            return $types = JobType::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    }

    public static function getJobTypesList()
    {
        return Cache::rememberForever('get-job-types-list', function () {
            return $types_list = JobType::where('status','Active')->pluck('name', 'id')->toArray();
        });
    }

    public static function typeById($id){
        $type_name = "";
        $type = JobType::where('status',JobType::ACTIVE)->where('id',$id)->first();
        if($type){
            return $type_name = $type->name;
        }

    }

    public static function getTypeIdByName($name)
    {
        $typeId = 0;
        $type = JobType::where('status',JobType::ACTIVE)->where('name',$name)->first();
        if($type){
            $typeId =  $type->id;
        }
        return $typeId;
    }
    
}
