<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobLoosePiece extends Model
{
    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'job_id', 'stock_no', 'weight', 'unit_price', 'price' ];

    protected $fillable = [ 'job_id', 'stock_no', 'weight', 'unit_price', 'price' ];

    public function job()
    {
        return $this->belongsTo(Job::class, 'job_id', 'id');
    }
}
