<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;

class JobImage extends Model
{
    const ACTIVE ="Active";
    const INACTIVE = "Inactive";
    const IMAGE_PATH = "img/jobs";
    const THUMB_IMAGE_PATH = 'img/jobs/thumb';
    const THUMB_SIZE = 70;
    
    use HasFactory;

    protected $fillable = [ 'job_id', 'image', 'status'];

    protected $appends = [ 'thumb_image_url', 'image_url' ];

    public function job()
    {
        return $this->belongsTo(Job::class, 'job_id', 'id');
    }

    public function getThumbImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::THUMB_IMAGE_PATH).'/'.$value)){
            return asset('public/img/jobs/thumb/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/jobs/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg');
        }
    }
}
