<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;

class JewelleryImage extends Model
{
    const ACTIVE ="Active";
    const INACTIVE = "Inactive";
    const IMAGE_PATH = "img/jewelleries";
    const THUMB_IMAGE_PATH = 'img/jewelleries/thumb';
    const THUMB_SIZE = 70;

    use HasFactory;

    protected $fillable = ['jewellery_id','image','status'];

    protected $appends = [ 'thumb_image_url', 'image_url' ];

    public function getThumbImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::THUMB_IMAGE_PATH).'/'.$value)){
            return asset('public/img/jewelleries/thumb/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/jewelleries/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg');
        }
    }

}
