<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes; //added by vd
use Illuminate\Database\Eloquent\Model;
use File;

class Jewellery extends Model
{
    use SoftDeletes; //added by vd
    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    const ZERO = "0";
    const ONE = "1";
    const ACTIVE = "Active";
    const INACTIVE = "Inactive";
    const ARCHIVED = "Archived";

    const FLAT = "Flat";
    const TEACUP = "Teacup";
    const LOOP = "Loop";
    const NO_BACKING_TYPE = "No Backing Type";

    const EAGLE = "Eagle";
    const ROUND = "Round";
    const SQUARE = "Square";
    const NO_CLAW = "No Claw";

    const INVENTORY = "Inventory";
    const BEPOKE = "Bepoke";

    const IMAGE_PATH = "img/jewelleries";
    const TEMP_PATH = "img/temp/";
    const THUMB_IMAGE_PATH = 'img/jewelleries/thumb';
    const THUMB_SIZE = 70;
    const DRAWING_IMAGE_PATH = "img/drawing_images";
    const SIGNATURE_PATH = "img/signature";

    public $sortable = ['id','item_code','type_id', 'category_id', 'status', 'created_at','total','mark_up','date'];


    protected $fillable = ['item_code', 'date', 'type_id', 'description', 'category_id', 'gold_color_id', 'size','awb_no', 'drawing_image'];

    protected $appends = [ 'drawing_image_url' ];

    public static function isSampleProvidedArray()
    {
        return [
            self::ZERO => self::ZERO,
            self::ONE => self::ONE,
        ];
    }

    public static function backingTypeArray()
    {
        return [
            self::FLAT => self::FLAT,
            self::TEACUP => self::TEACUP,
            self::LOOP => self::LOOP,
            self::NO_BACKING_TYPE => self::NO_BACKING_TYPE,
        ];
    }

    public static function clawArray()
    {
        return [
            self::EAGLE => self::EAGLE,
            self::ROUND => self::ROUND,
            self::SQUARE => self::SQUARE,
            self::NO_CLAW => self::NO_CLAW,
        ];
    }

    public function staff()
    {
        return $this->belongsTo(Admin::class, 'staff_id', 'id');
    }

    public function type()
    {
        return $this->belongsTo(Type::class, 'type_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function images()
    {
        return $this->hasMany('\App\Models\JewelleryImage', 'jewellery_id', 'id');

    }

    public function first_image()
    {
        return $this->hasOne(JewelleryImage::class, 'jewellery_id', 'id')->latest();
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    public function loose_pieces()
    {
        return $this->hasMany(JewelleryLoosePiece::class, 'jewellery_id', 'id');
    }

    public function review_cost()
    {
        return $this->hasOne(ReviewCost::class, 'jewellery_id', 'id');
    }

    public function job()
    {
        return $this->belongsTo(Job::class, 'job_id', 'id');
    }

    public function gold_color()
    {
        return $this->belongsTo(GoldColor::class, 'gold_color_id', 'id');
    }

    public static function getItemCodeArray()
    {
        $result ="";
        $jewellery = Jewellery::whereHas('review_cost', function($q)
        {
          $q->where('total','!=', 0);
        })->pluck('item_code')->toArray();
   
        if($jewellery){
            $result = $jewellery;
        }else{
            $result = " ";
        }
        return  $result;
    }

    public static function getJewelleryByItemCode($item_code)
    {
        $jewellery =Jewellery::with(['category', 'review_cost', 'gold_color'])->where('item_code', $item_code)->first();
        if($jewellery){
            return $jewellery;
        }else{
            return $jewellery = null;
        }
    }

    public static function defaultImage()
    {
        return asset('public/img/default-placeholder.jpg');
    }

    public function getDrawingImageUrlAttribute()
    {
        $value = $this->attributes['drawing_image'];
        if (!empty($value) && File::exists(public_path(Self::DRAWING_IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/drawing_images/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg'); 
            // image_necklace.png
        }
    }
}

