<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder; // added by ss
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceItem extends Model
{
    const BESPOKE = "Bespoke";
    const REPAIR = "Repair";
    const INVENTORY = "Inventory";

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'invoice_id', 'quotation_item_id', 'jewellery_id',	'job_id', 'item_code', 'category_id', 'gold_color_id', 'additional_material', 'material_quantity', 'additional_info', 'description', 'customer_received', 'price', 'sub_total', 'created_at' ];
    
    protected $fillable = [ 'invoice_id', 'quotation_item_id', 'jewellery_id', 'job_id', 'item_code', 'category_id', 'gold_color_id', 'additional_material', 'material_quantity', 'additional_info', 'description', 'customer_received', 'price', 'valued_at', 'sub_total' ];

    public function jewellery()
    {
       return $this->belongsTo(Jewellery::Class, 'jewellery_id', 'id');
    }

    public function job()
    {
       return $this->belongsTo(Job::Class, 'job_id', 'id');
    }

    public function invoice()
    {
       return $this->belongsTo(Invoice::Class, 'invoice_id', 'id');
    }

    public function quotation_item()
    {
       return $this->belongsTo(QuotationItem::Class, 'quotation_item_id', 'id');
    }

    public function gold_color()
    {
        return $this->belongsTo(GoldColor::class, 'gold_color_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function scopeToday($query)
    {
        $query->whereDate('invoice_items.created_at', date('Y-m-d'));
    }

    //-------------------------------------------------------------------------

    public static function checkInvoiceByQuotationItem($quotation_item_id)
    {
      $invoice  = InvoiceItem::where('quotation_item_id',$quotation_item_id)->first();
      if(!empty($invoice)){
        return true;
      }else{
        return false;
      }
    }

}
