<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class GoldColor extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'name', 'status' ];
    
    protected $fillable = [ 'name', 'status' ];

    const DEFAULT_SELECT = [ 'id', 'name' ];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();
     
        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        }); 
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-gold-colors');  
        Cache::forget('get-gold-colors-list');
    }

    public function jewellery()
    {
        return $this->hasMany(Jewellery::class, 'gold_color_id', 'id');
    }

    public function job()
    {
        return $this->hasMany(Job::class, 'gold_color_id', 'id');
    }

    public function quotation()
    {
        return $this->hasMany(Quotation::class, 'gold_color_id', 'id');
    }

    public static function getGoldColors()
    {
        return Cache::rememberForever('get-gold-colors', function () {
            return $gold_colors = GoldColor::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    } 

    public static function getGoldColorsList()
    {
        return Cache::rememberForever('get-gold-colors-list', function () {
            return $gold_colors_list = GoldColor::where('status','Active')->pluck('name', 'id');
        });
    }

    public static function getGoldColorNameById($id){
        if($id){
            $goldColor =  GoldColor::where('id',$id)->firstOrFail();
            if($goldColor){
                return $goldColor->name;
            }else{
                return $goldColor = "";
            }
        }
    }

}
