<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConsignmentItem extends Model
{
    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'consignment_id', 'category_id', 'weight', 'unit', 'unit_price', 'total_price', 'used', 'remainder', 'created_at' ];

    protected $fillable = [ 'consignment_id','category_id','description','weight', 'unit','unit_price','total_price', 'used', 'remainder', 'status' ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function consignment()
    {
        return $this->belongsTo(Consignment::class);
    }
}
