<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Log;

class Consignment extends Model
{
    const ZERO = "0";
    const ONE = "1";
    const FLAT = "Flat";
    const TEACUP = "Teacup";
    const LOOP = "Loop";
    const EAGLE = "Eagle";
    const ROUND = "Round";
    const SQUARE = "Square";
    const INVENTORY = "Inventory";
    const BEPOKE = "Bepoke";
    const CONSIGNMENT = "Consignment";

    // const IMAGE_PATH = "img/jewelleries";
    // const TEMP_PATH = "img/temp/";

    // const SIGNATURE_PATH = "img/signature";

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'consignment_no', 'reference_date', 'staff_id', 'customer_id', 'customer_name', 'customer_email', 'country_code', 'customer_phone', 'receiving_date', 'status' ];


    protected $fillable = [ 'consignment_no', 'reference_date', 'staff_id', 'customer_id', 'customer_name', 'customer_email', 'country_code', 'customer_phone', 'customer_signature', 'sales_representative_signature', 'receiving_date', 'status' ];

    protected $appends = [ 'phone_with_code' ];

    public function consignment_item()
    {
        return $this->hasOne(ConsignmentItem::class);
    }

    public function consignment_review_cost()
    {
        return $this->hasOne(ConsignmentReviewCost::class, 'consignment_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    public function getPhoneWithCodeAttribute()
    {
        return isset($this->customer_phone) ? ($this->country_code ? $this->country_code.' '.$this->customer_phone : $this->customer_phone) : ( ($this->customer) ? $this->customer->customer_phone : '-');
    }

    
}
