<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use File;

class Category extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    const RING = "Ring";

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    const IMAGE_PATH = 'img/categories/';

    public $sortable = ['id', 'name', 'status', 'created_at'];

    protected $fillable = ['name', 'image','icon_image', 'status'];

    const DEFAULT_SELECT = ['id', 'name', 'image'];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();

        self::created(function ($model) {
            self::deleteCache($model);
        });

        self::updated(function ($model) {
            self::deleteCache($model);
        });

        self::deleted(function ($model) {
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-categories');
        Cache::forget('get-categories-list');
    }

    public function size()
    {
        return $this->hasMany('\App\Models\Size');
    }

    public function quotation_item()
    {
        return $this->hasMany(QuotationItem::class, 'category_id', 'id');
    }

    public function invoice_item()
    {
        return $this->hasMany(InvoiceItem::class, 'category_id', 'id');
    }

    public static function getCategories()
    {
        return Cache::rememberForever('get-categories', function () {
            return $categories = Category::where('status', Category::ACTIVE)->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    }

    //    public static function getCategoriesList()
    //    {
    //        return Cache::rememberForever('get-categories-list', function () {
    //            return $categories = Category::where('status', Category::ACTIVE)->pluck('name','id')->toArray();
    //        });
    //    }

    public static function getCategoriesList()
    {
        return Cache::rememberForever('get-categories-list', function () {
            return $categories = Category::where('status', Category::ACTIVE)->get();
        });
    }

    public function getImageAttribute($value)
    {
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/categories/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getIconImageAttribute($value)
    {
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/categories/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg');
        }
    }

    // public function getImageAttribute($value)
    // {
    //     if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH).$value)){
    //         return asset('public/img/activities/'.$value);
    //     }else{
    //         return asset('public/img/default-placeholder.jpg');
    //     }
    // }

    public static function getCategoryNameById($id){
        if($id){
            $categories =  Category::where('id',$id)->firstOrFail();
            if($categories){
                return $categories->name;
            }else{
                return $categories = "Jewelleries";
            }
        }else{

        }
    }


}
