<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class BackingType extends Model
{
    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';

    use HasFactory;

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'name', 'status' ];
    
    protected $fillable = [ 'name', 'status' ];

    const DEFAULT_SELECT = [ 'id', 'name' ];

    const DEFAULT_HIDE = ['status', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();
     
        self::created(function($model){
            self::deleteCache($model);
        });

        self::updated(function($model){
            self::deleteCache($model);
        });

        self::deleted(function($model){
            self::deleteCache($model);
        }); 
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-backing-types');
        Cache::forget('get-backing-types-list');  
    }

    public static function getBackingTypes()
    {
        return Cache::rememberForever('get-backing-types', function () {
            return $backing_types = BackingType::where('status','Active')->get(self::DEFAULT_SELECT)->makeHidden(self::DEFAULT_HIDE);
        });
    } 

    public static function getBackingTypesList()
    {
        return Cache::rememberForever('get-backing-types-list', function () {
            return $backing_types_list = BackingType::where('status','Active')->pluck('name', 'id')->toArray();
        });
    } 

}
